define([
    'underscore',
    'models/abstract-collection',
    'modules/new-appointment-request/resources/constants',
], function(_, Collection, constants) {
    'use strict';


    var EXPRESS_CARE_NAME = 'Express Care';
    var EXPRESS_CARE_TYPE = 'TypesOfCare';
    var RESOURCE_NAME = 'clinical-services';


    return Collection.extend({
        resourceName: RESOURCE_NAME,

        parse: function(response) {
            var _response = response || [];

            if (!this.isExpressCareInResponse(_response)) {
                _response.push(this.expressCareFactory());
            }
            return _response;
        },

        expressCareFactory: function() {
            return {
                id: constants.EXPRESS_CARE_ID,
                name: EXPRESS_CARE_NAME,
                objectType: EXPRESS_CARE_TYPE,
                link: [],
            };
        },

        isExpressCareInResponse: function(response) {
            var expressCare = _.find(response, {id: constants.EXPRESS_CARE_ID});
            return !_.isUndefined(expressCare);
        },

        url: function() {
            var resource = this.getResource();
            return resource.formatHref();
        },

        comparator: function(model) {
            if (model.id === constants.PRIMARY_CARE_ID) {
                return String.fromCharCode(0);
            }
            return model.get('name');
        },
    });
});
